/* Copyright (c) 2017-2018 VMware, Inc. All rights reserved. -- VMware Confidential */
export interface NewTransInfo {
   oldArgs: string[],
   newName: string,
   newArgs: string,
   postfix: string
}

interface Transformation {
   namespace: string,
   objects: string[],
   functionTransformations: {[methodName: string]: NewTransInfo},
   errorMessages: {[methodName: string]: string}
}

export class TransformationInfo {
   transformation: Transformation;

   constructor(transformationsPath: string) {
      this.transformation = TransformationInfo.readConfigFile(transformationsPath);
      this.transformation.objects = ["WEB_PLATFORM"];
   }

   getObjects(): string[] {
      return this.transformation.objects;
   }

   getNamespace(): string {
      return this.transformation.namespace;
   }

   getFunctionTransfromations() {
      return this.transformation.functionTransformations;
   }

   getErrorMessages() {
      return this.transformation.errorMessages;
   }

   static readConfigFile(filePath: string): Transformation {
      let object : Transformation = require(filePath);
      return object;
   }
}